//
//  TestController.m
//  POSSDKForIOSDemo
//
//  Created by xieyunming on 17/1/12.
//
//

#import "TestController.h"
#import "ButtonPullDownPrepare.h"
#import "ButtonPullDownRealize.h"

@interface TestController ()
{
    NSArray* titleArr;
    NSInteger selectedColor;
     NSInteger selectedColor2;
}
@end

@implementation TestController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self creatUI];
}

#pragma  mark - creatUI
-(void)creatUI{
    NSInteger HeightY = self.view.frame.size.height-160;
    
    _printBtn = [[UIButton alloc]initWithFrame:CGRectMake(260, HeightY, 100, 40)];
    _printBtn.layer.borderWidth = 1;
    _printBtn.layer.borderColor = [UIColor blackColor].CGColor;
    _printBtn.layer.cornerRadius = 5;
    [_printBtn setTitle:@"打印" forState:UIControlStateNormal];
    [_printBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [_printBtn addTarget:self action:@selector(customPrint) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_printBtn];
    
    _cut = [[UIButton alloc]initWithFrame:CGRectMake(140, HeightY, 100, 40)];
    _cut.layer.borderWidth = 1;
    _cut.layer.borderColor = [UIColor blackColor].CGColor;
    _cut.layer.cornerRadius = 5;
    [_cut setTitle:@"切纸" forState:UIControlStateNormal];
    [_cut setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [_cut addTarget:self action:@selector(printLineAndCut) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_cut];
    
    
    _dissBtn = [[UIButton alloc]initWithFrame:CGRectMake(20, HeightY, 100, 40)];
    _dissBtn.layer.borderWidth = 1;
    _dissBtn.layer.borderColor = [UIColor blackColor].CGColor;
    _dissBtn.layer.cornerRadius = 5;
    [_dissBtn setTitle:@"返回" forState:UIControlStateNormal];
    [_dissBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [_dissBtn addTarget:self action:@selector(back) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:_dissBtn];

    
    _textField1 = [[UITextField alloc]initWithFrame:CGRectMake(150, 100, 200, 30)];
    _textField1.backgroundColor = [UIColor redColor];
    _textField1.textColor = [UIColor blackColor];
    _textField1.text = @"30";
    [self.view addSubview:_textField1];
    _textField2 = [[UITextField alloc]initWithFrame:CGRectMake(150, 140, 200, 30)];
    _textField2.backgroundColor = [UIColor redColor];
    _textField2.textColor = [UIColor blackColor];
    _textField2.text = @"300";
    [self.view addSubview:_textField2];
    _textField3 = [[UITextField alloc]initWithFrame:CGRectMake(150, 180, 200, 30)];
    _textField3.backgroundColor = [UIColor redColor];
    _textField3.textColor = [UIColor blackColor];
    _textField3.text = @"30";
    [self.view addSubview:_textField3];
    
    _selectColorBtn = [[UIButton alloc]initWithFrame:CGRectMake(150,220,200,30)];
    [_selectColorBtn setTitle:@"PrintColorDouble" forState:UIControlStateNormal];
    [_selectColorBtn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [_selectColorBtn addTarget:self action:@selector(selectColor:) forControlEvents:UIControlEventTouchUpInside];
    _selectColorBtn.backgroundColor = [UIColor redColor];
    [self.view addSubview:_selectColorBtn];
    
    _selectColorBtn2 = [[UIButton alloc]initWithFrame:CGRectMake(150,260,200,30)];
    [_selectColorBtn2 setTitle:@"PrintColorFirst" forState:UIControlStateNormal];
    [_selectColorBtn2 setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [_selectColorBtn2 addTarget:self action:@selector(selectColor2:) forControlEvents:UIControlEventTouchUpInside];
    _selectColorBtn2.backgroundColor = [UIColor redColor];
    [self.view addSubview:_selectColorBtn2];
    
    titleArr = @[@"LeftMargin",@"PrintWidth",@"HorizonPosition",@"PrintColor",@"ColorPrint"];
    for (NSInteger i = 0; i < titleArr.count; i++) {
        UILabel* titleLabel = [[[UILabel alloc]initWithFrame:CGRectMake(20, 100+i*40, 130, 30)] autorelease];
        titleLabel.text = titleArr[i];
        titleLabel.textColor = [UIColor blackColor];
        [self.view addSubview:titleLabel];
    }
    
    selectedColor = 0;
    selectedColor2 = 0;
    [self.array_color addObjectsFromArray:@[@"PrintColorNormal",@"PrintColorDouble"]];
     [self.array_color2 addObjectsFromArray:@[@"PrintColorFirst",@"PrintColorSecond"]];
    
}
-(void)selectColor:(UIButton*)sender{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        selectedColor = selectedIndex;
        [self.selectColorBtn setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    NSLog(@"%@",self.array_color);
    [ButtonPullDownRealize sheetPickerTitle:@"selectColor" Sheet:self.array_color Selected:selectedColor DoneButton:done CancelButton:cancel Action:sender];
}
-(void)selectColor2:(UIButton*)sender{
    PickerActionDoneButton done = ^(ButtonPullDownRealize *picker, NSInteger selectedIndex, id selectedValue)
    {
        selectedColor2 = selectedIndex;
        [self.selectColorBtn2 setTitle:selectedValue forState:UIControlStateNormal];
    };
    
    PickerActionCancelButton cancel = ^(ButtonPullDownRealize *picker)
    {
    };
    NSLog(@"%@",self.array_color);
    [ButtonPullDownRealize sheetPickerTitle:@"selectColor2" Sheet:self.array_color2 Selected:selectedColor2 DoneButton:done CancelButton:cancel Action:sender];
}
-(NSMutableArray*)array_color{
    if (!_array_color) {
        _array_color = [NSMutableArray new];
    }
    return _array_color;
}
-(NSMutableArray*)array_color2{
    if (!_array_color2) {
        _array_color2 = [NSMutableArray new];
    }
    return _array_color2;
}
-(void)customPrint{
    SInt32 error_code = SUCCESS;
    if (_textField1.text.length == 0 ||_textField2.text.length == 0 ||_textField3.text.length == 0  ) {
        AlertViewShow(@"can not empty!");
        return ;
    }
    [self.pos_sdk standardModeSetPrintLeftMargin:[_textField1.text intValue]];

    [self.pos_sdk standardModeSetPrintWidth:[_textField2.text intValue]];
    
    [self.pos_sdk standardModeSetStartingPosition:[_textField3.text intValue]];
    
    if ([self.selectColorBtn.titleLabel.text isEqualToString:@"PrintColorNormal"]) {
        [self.pos_sdk textEnterOrQuitColorPrint:PrintColorNormal];
    }else{
        [self.pos_sdk textEnterOrQuitColorPrint:PrintColorDouble];
    }
    
    if ([self.selectColorBtn2.titleLabel.text isEqualToString:@"PrintColorFirst"]) {
           [self.pos_sdk textSetColorPrint:PrintColorFirst];
    }else{
          [self.pos_sdk textSetColorPrint:PrintColorSecond];
    }
    
    
    [self.pos_sdk textPrint:@"We strive to be the expert supplier of printers.Our POS series printers can print text,image and barcode.It's a wise choice for you to choose our printers."];
    
    
    //Set Motion Unit
    error_code = [self.pos_sdk systemSetMotionUnit:203 VerticalUnit:203];
    if (error_code != SUCCESS)
    {
        AlertViewShow(@"ERROR TimeOut! Please reconnect Printer.");
        return;
    }
    
    [self.pos_sdk systemFeedLine:2];
}

-(void)back{
    [self dismissViewControllerAnimated:YES completion:nil];
}

-(void)printLineAndCut{
    SInt32   error_code       = SUCCESS;
    //Feed Line
    error_code = [self.pos_sdk systemFeedLine:2];
    if (error_code != SUCCESS)
    {
        return;
    }
    //cut paper
    error_code = [self.pos_sdk systemCutPaper:CutPartAfterFeed FeedDistance:50];
    if (error_code != SUCCESS)
    {
        return;
    }
}
#pragma mark - dealloc
-(void)dealloc{
    
    [_array_color release];
    [_textField1 release];
    [_textField2 release];
    [_pos_sdk  release];
    [_printBtn release];
    [_dissBtn release];
    [super dealloc];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
